% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{binCount2D}
\alias{binCount2D}
\title{Bin-count Matrix Data}
\usage{
binCount2D(x, y, xbreaks, ybreaks, flatten = FALSE, include.lowest = FALSE)
}
\arguments{
\item{x, y}{vectors of numerical values.}

\item{xbreaks, ybreaks}{vector of values of \code{x} and \code{y}
at the boundaries between the 2D bins, calculated using
\code{\link[=pretty]{pretty()}} on each of \code{x} and \code{y}, if not supplied.}

\item{flatten}{A logical value indicating whether
the return value also contains equilength
vectors \code{x}, \code{y}, \code{z} and \code{n}, a flattened
representation of \code{xmids}, \code{ymids}, \code{result} and
\code{number}.}

\item{include.lowest}{logical value indicating whether to include
points where \code{x} equals \code{xbreaks[1]} or \code{y} equals \code{ybreaks[1]}.}
}
\value{
A list with the following elements: the breaks (\code{xbreaks}
and \code{ybreaks}), the midpoints (\code{xmids} and \code{ymids})
between those breaks, and
the count (\code{number}) of \code{f} values in the boxes defined
between successive breaks.
}
\description{
Count the number of elements of a given matrix z=z(x,y) that fall within
successive pairs of breaks in x and y.
}
\details{
By default, the sub-intervals defined by \code{xbreaks} and \code{ybreaks}
are open on the left/bottom and closed on the right/top, to match
the behaviour of \code{\link[=cut]{cut()}}.  An open interval does not include
points on the boundary, and so any \code{x} and \code{y} values that equal
\code{xbreaks[1]} or \code{ybreaks[1]} will not be counted.  To include
such points in the calculation, set \code{include.lowest} to TRUE.
}
\seealso{
Other bin-related functions: 
\code{\link{binApply1D}()},
\code{\link{binApply2D}()},
\code{\link{binAverage}()},
\code{\link{binCount1D}()},
\code{\link{binMean1D}()},
\code{\link{binMean2D}()}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
