% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{T90fromT48}
\alias{T90fromT48}
\title{Convert From ITS-48 to ITS-90 Temperature}
\usage{
T90fromT48(temperature)
}
\arguments{
\item{temperature}{Vector of temperatures in \eqn{^\circ}{deg}C on the IPTS-48 scale.}
}
\value{
Corresponding temperatures in \eqn{^\circ}{deg}C on the ITS-90 scale.
}
\description{
Today's instruments typically record in the ITS-90 scale, but some old
datasets will be in the IPTS-68 scale. \code{T90fromT68()} converts from the
IPTS-68 to the ITS-90 scale, using Saunders' (1990) formula, while
\code{T68fromT90()} does the reverse. The difference between IPTS-68 and
ITS-90 values is typically a few millidegrees (see \sQuote{Examples}), which
is seldom visible on a typical temperature profile, but may be of interest
in some precise work.  Mostly for historical interest, \code{T90fromT48()}
is provided to convert from the ITS-48 system to ITS-90.
}
\examples{
library(oce)
T68 <- seq(3, 20, 1)
T90 <- T90fromT68(T68)
sqrt(mean((T68-T90)^2))

}
\references{
P. M. Saunders, 1990. The international temperature scale of
1990, ITS-90.  WOCE Newsletter, volume 10, September 1990, page 10.
http://www.nodc.noaa.gov/woce/wdiu/wocedocs/newsltr/news10/contents.htm
}
\seealso{
Other functions that calculate seawater properties: 
\code{\link{T68fromT90}()},
\code{\link{T90fromT68}()},
\code{\link{computableWaterProperties}()},
\code{\link{locationForGsw}()},
\code{\link{swAbsoluteSalinity}()},
\code{\link{swAlphaOverBeta}()},
\code{\link{swAlpha}()},
\code{\link{swBeta}()},
\code{\link{swCSTp}()},
\code{\link{swConservativeTemperature}()},
\code{\link{swDepth}()},
\code{\link{swDynamicHeight}()},
\code{\link{swLapseRate}()},
\code{\link{swN2}()},
\code{\link{swPressure}()},
\code{\link{swRho}()},
\code{\link{swRrho}()},
\code{\link{swSCTp}()},
\code{\link{swSR}()},
\code{\link{swSTrho}()},
\code{\link{swSigma0}()},
\code{\link{swSigma1}()},
\code{\link{swSigma2}()},
\code{\link{swSigma3}()},
\code{\link{swSigma4}()},
\code{\link{swSigmaTheta}()},
\code{\link{swSigmaT}()},
\code{\link{swSigma}()},
\code{\link{swSoundAbsorption}()},
\code{\link{swSoundSpeed}()},
\code{\link{swSpecificHeat}()},
\code{\link{swSpice}()},
\code{\link{swSstar}()},
\code{\link{swTFreeze}()},
\code{\link{swTSrho}()},
\code{\link{swThermalConductivity}()},
\code{\link{swTheta}()},
\code{\link{swViscosity}()},
\code{\link{swZ}()}
}
\author{
Dan Kelley
}
\concept{functions that calculate seawater properties}
