% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceFileTrim}
\alias{oceFileTrim}
\title{Trim an oce File}
\usage{
oceFileTrim(infile, n = 100L, outfile, debug = getOption("oceDebug"))
}
\arguments{
\item{infile}{name of an AD2CP source file.}

\item{n}{integer indicating the number of data chunks to keep. The default is
to keep 100 chunks, a common good choice for sample files.}

\item{outfile}{optional name of the new file to be created. If this is not
supplied, a default is used, by adding \verb{_trimmed} to the base filename, e.g.
for an AD2CP file named \code{"a.ad2cp"}, the constructed value of \code{outfile} will
be \code{a_trimmed.ad2cp}.}

\item{debug}{an integer value indicating the level of debugging. If
this is 1L, then a brief indication is given of the processing steps. If it
is > 1L, then information is given about each data chunk, which can yield
very extensive output.}
}
\value{
\code{oceFileTrim()} returns the name of the output file, either provided
in the \code{outfile} parameter or constructed by this function.
}
\description{
Create an oce file by copying the first \code{n} data chunks of another such file.
This can be useful in supplying small sample files for bug reports. Only
a few file types (as inferred with \code{\link[=oceMagic]{oceMagic()}}) are permitted.
}
\examples{
\dontrun{
# Can only be run by the developer, since it uses a private file.
f  <- "/Users/kelley/Dropbox/oce_secret_data/ad2cp/byg_trimmed.ad2cp"
if (file.exists(f)) {
    oceFileTrim(f, 10L) # this file holds 100 data segments
}
}
}
\seealso{
Other functions that trim data files: 
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{advSontekAdrFileTrim}()}
}
\author{
Dan Kelley
}
\concept{functions that trim data files}
