% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\name{composite,amsr-method}
\alias{composite,amsr-method}
\title{Create a composite of amsr satellite data}
\usage{
\S4method{composite}{amsr}(object, ...)
}
\arguments{
\item{object}{An \linkS4class{amsr} object.}

\item{...}{Other amsr objects.}
}
\description{
Form averages for each item in the \code{data} slot of the supplied objects,
taking into account the bad-data codes.

Items within the \code{data} slots of the
objects that are supplied as arguments are averaged in a way that
makes sense for the object class, i.e. taking into account
the particular bad-data codes of that particular class.
}
\details{
If none of the objects has good
data at any particular pixel (i.e. particular latitude and longitude),
the resultant will have the bad-data code of the last item in the argument
list.
The metadata in the result are taken directly from the metadata of the
final argument, except that the filename is set to a comma-separated list
of the component filenames.
}
\seealso{
Other things related to amsr data: 
\code{\link{[[,amsr-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{amsr-class}},
\code{\link{amsr}},
\code{\link{download.amsr}()},
\code{\link{plot,amsr-method}},
\code{\link{read.amsr}()},
\code{\link{subset,amsr-method}},
\code{\link{summary,amsr-method}}

Other functions that create composite objects: 
\code{\link{composite,list-method}},
\code{\link{composite}()}
}
\concept{functions that create composite objects}
\concept{things related to amsr data}
