% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\docType{methods}
\name{subset,adp-method}
\alias{subset,adp-method}
\title{Subset an ADP Object}
\usage{
\S4method{subset}{adp}(x, subset, ...)
}
\arguments{
\item{x}{An \code{adp} object, i.e. one inheriting from \code{\link{adp-class}}.}

\item{subset}{A condition to be applied to the \code{data} portion of
\code{x}.  See \sQuote{Details}.}

\item{...}{Ignored.}
}
\value{
A new \code{\link{adp-class}} object.
}
\description{
Subset an adp (acoustic Doppler profile) object, in a manner that is function
is somewhat analogous to \code{\link{subset.data.frame}}. For any data type,
subsetting can be by \code{time} or \code{distance}, but these may not be
combined; use a sequence of calls to subset by both. For the special
case of AD2CP data (see \code{\link{read.adp.ad2cp}}), it is possible to subset
to the "average" data records with \code{subset="average"}, to the
"burst" records with \code{subset="burst"}, or to the "interleavedBurst"
with \code{subset="interleavedBurst"}; note that no warning is issued,
if this leaves an object with no useful data.
}
\examples{
library(oce)
data(adp)
# First part of time series
plot(subset(adp, time < mean(range(adp[['time']]))))

}
\seealso{
Other things related to adp data: \code{\link{[[,adp-method}},
  \code{\link{[[<-,adp-method}},
  \code{\link{ad2cpHeaderValue}}, \code{\link{adp-class}},
  \code{\link{adpEnsembleAverage}}, \code{\link{adp}},
  \code{\link{as.adp}}, \code{\link{beamName}},
  \code{\link{beamToXyzAdpAD2CP}},
  \code{\link{beamToXyzAdp}}, \code{\link{beamToXyzAdv}},
  \code{\link{beamToXyz}}, \code{\link{beamUnspreadAdp}},
  \code{\link{binmapAdp}}, \code{\link{enuToOtherAdp}},
  \code{\link{enuToOther}},
  \code{\link{handleFlags,adp-method}},
  \code{\link{is.ad2cp}}, \code{\link{plot,adp-method}},
  \code{\link{read.adp.ad2cp}},
  \code{\link{read.adp.nortek}},
  \code{\link{read.adp.rdi}},
  \code{\link{read.adp.sontek.serial}},
  \code{\link{read.adp.sontek}}, \code{\link{read.adp}},
  \code{\link{read.aquadoppHR}},
  \code{\link{read.aquadoppProfiler}},
  \code{\link{read.aquadopp}}, \code{\link{rotateAboutZ}},
  \code{\link{setFlags,adp-method}},
  \code{\link{summary,adp-method}}, \code{\link{toEnuAdp}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdpAD2CP}},
  \code{\link{xyzToEnuAdp}}, \code{\link{xyzToEnu}}

Other functions that subset oce objects: \code{\link{subset,adv-method}},
  \code{\link{subset,amsr-method}},
  \code{\link{subset,argo-method}},
  \code{\link{subset,cm-method}},
  \code{\link{subset,coastline-method}},
  \code{\link{subset,ctd-method}},
  \code{\link{subset,echosounder-method}},
  \code{\link{subset,lobo-method}},
  \code{\link{subset,met-method}},
  \code{\link{subset,oce-method}},
  \code{\link{subset,odf-method}},
  \code{\link{subset,rsk-method}},
  \code{\link{subset,sealevel-method}},
  \code{\link{subset,section-method}},
  \code{\link{subset,topo-method}}
}
\author{
Dan Kelley
}
\concept{functions that subset oce objects}
\concept{things related to adp data}
