% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{methods}
\name{plot,oce-method}
\alias{plot,oce-method}
\alias{plot.oce}
\title{Plot an oce Object}
\usage{
\S4method{plot}{oce}(x, y, ...)
}
\arguments{
\item{x}{A basic \code{oce} object, i.e. one inheriting from \code{\link{oce-class}},
but not from any subclass of that (because these subclasses go to the subclass
plot methods, e.g. a \code{\link{ctd-class}} object would go to
\code{\link{plot,ctd-method}}.}

\item{y}{Ignored; only present here because S4 object for generic \code{plot}
need to have a second parameter before the \code{...} parameter.}

\item{...}{Passed to \code{\link{hist}}, \code{\link{plot}}, or to
\code{\link{pairs}}, according to whichever does the plotting.}
}
\description{
This creates a \code{\link{pairs}} plot of the elements in the \code{data}
slot, if there are more than 2 elements there, or a simple xy plot if 2
elements, or a histogram if 1 element.
}
\examples{
library(oce)
o <- new("oce")
o <- oceSetData(o, 'x', rnorm(10))
o <- oceSetData(o, 'y', rnorm(10))
o <- oceSetData(o, 'z', rnorm(10))
plot(o)
}
