% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\name{as.argo}
\alias{as.argo}
\title{Coerce Data Into an Argo Dataset}
\usage{
as.argo(time, longitude, latitude, salinity, temperature, pressure,
  units = NULL, id, filename = "", missingValue)
}
\arguments{
\item{time}{vector of POSIXct times.}

\item{longitude}{vector of longitudes.}

\item{latitude}{vector of latitudes.}

\item{salinity}{vector of salinities.}

\item{temperature}{vector of temperatures.}

\item{pressure}{vector of pressures.}

\item{units}{optional list containing units. If \code{NULL}, the default,
then \code{"degree east"} is used for \code{longitude},
\code{"degree north"} for \code{latitude},
\code{""} for \code{salinity},
\code{"ITS-90"} for \code{temperature}, and
\code{"dbar"} for \code{pressure}.}

\item{id}{identifier.}

\item{filename}{source filename.}

\item{missingValue}{Optional missing value, indicating data values that should be
taken as \code{NA}.}
}
\value{
An object of \code{\link{argo-class}}.
}
\description{
Coerce a dataset into an argo dataset. This is not the right way to
read official argo datasets, which are provided in NetCDF format and may
be read with \code{\link{read.argo}}.
}
\seealso{
The documentation for \code{\link{argo-class}} explains the structure of argo
objects, and also outlines the other functions dealing with them.

Other things related to \code{argo} data: \code{\link{[[,argo-method}},
  \code{\link{[[<-,argo-method}}, \code{\link{argo-class}},
  \code{\link{argoGrid}}, \code{\link{argoNames2oceNames}},
  \code{\link{argo}},
  \code{\link{handleFlags,argo-method}},
  \code{\link{plot,argo-method}}, \code{\link{read.argo}},
  \code{\link{subset,argo-method}},
  \code{\link{summary,argo-method}}
}
\author{
Dan Kelley
}
\concept{things related to \code{argo} data}
