% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ad.R
\name{velocityStatistics}
\alias{velocityStatistics}
\title{Report Statistics of adp or adv Velocities}
\usage{
velocityStatistics(x, control, ...)
}
\arguments{
\item{x}{an \code{adp} or \code{adv} object, i.e. one inheriting from
\code{\link{adp-class}} or \code{\link{adv-class}}.}

\item{control}{An optional \code{\link{list}} used to specify more information.
This is presently ignored for \code{adv} objects.  For \code{adp} objects, if
\code{control$bin} is an integer, it is taken as the bin to be selected
(otherwise, an average across bins is used).}

\item{\dots}{additional arguments that are used in the call to
\code{\link{mean}}.}
}
\value{
A list containing items the major and minor axes of the covariance
ellipse (\code{ellipseMajor} and \code{ellipseMinor}), the angle of the
major axis anticlockwise of the horizontal axis (\code{ellipseAngle}), and
the x and y components of the mean velocity (\code{uMean} and \code{vMean}).
}
\description{
Report statistics of ADP or ADV velocities, such as means and variance
ellipses.
}
\examples{
library(oce)
data(adp)
a <- velocityStatistics(adp)
print(a)
t <- seq(0, 2*pi, length.out=100)
theta <- a$ellipseAngle * pi / 180
y <- a$ellipseMajor * cos(t) * sin(theta) + a$ellipseMinor * sin(t) * cos(theta)
x <- a$ellipseMajor * cos(t) * cos(theta) - a$ellipseMinor * sin(t) * sin(theta)
plot(adp, which="uv+ellipse+arrow")
lines(x, y, col='blue', lty="dashed", lwd=5)
arrows(0, 0, a$uMean, a$vMean, lwd=5, length=1/10, col='blue', lty="dashed")

}
\seealso{
Other things related to \code{adp} data: \code{\link{[[,adp-method}},
  \code{\link{[[<-,adp-method}}, \code{\link{adp-class}},
  \code{\link{adpEnsembleAverage}}, \code{\link{adp}},
  \code{\link{as.adp}}, \code{\link{beamName}},
  \code{\link{beamToXyzAdp}}, \code{\link{beamToXyzAdv}},
  \code{\link{beamToXyz}}, \code{\link{beamUnspreadAdp}},
  \code{\link{binmapAdp}}, \code{\link{enuToOtherAdp}},
  \code{\link{enuToOther}}, \code{\link{plot,adp-method}},
  \code{\link{read.ad2cp}}, \code{\link{read.adp.nortek}},
  \code{\link{read.adp.rdi}},
  \code{\link{read.adp.sontek.serial}},
  \code{\link{read.adp.sontek}}, \code{\link{read.adp}},
  \code{\link{read.aquadoppHR}},
  \code{\link{read.aquadoppProfiler}},
  \code{\link{read.aquadopp}},
  \code{\link{subset,adp-method}},
  \code{\link{summary,adp-method}}, \code{\link{toEnuAdp}},
  \code{\link{toEnu}}, \code{\link{xyzToEnuAdp}},
  \code{\link{xyzToEnu}}

Other things related to \code{adv} data: \code{\link{[[,adv-method}},
  \code{\link{[[<-,adv-method}}, \code{\link{adv-class}},
  \code{\link{adv}}, \code{\link{beamName}},
  \code{\link{beamToXyz}}, \code{\link{enuToOtherAdv}},
  \code{\link{enuToOther}}, \code{\link{plot,adv-method}},
  \code{\link{read.adv.nortek}},
  \code{\link{read.adv.sontek.adr}},
  \code{\link{read.adv.sontek.serial}},
  \code{\link{read.adv.sontek.text}},
  \code{\link{read.adv}}, \code{\link{subset,adv-method}},
  \code{\link{summary,adv-method}}, \code{\link{toEnuAdv}},
  \code{\link{toEnu}}, \code{\link{xyzToEnuAdv}},
  \code{\link{xyzToEnu}}
}
\author{
Dan Kelley
}
