% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\docType{methods}
\name{[[,adp-method}
\alias{[[,adp-method}
\title{Extract Parts of an ADP Object

In addition to the usual extraction of elements by name, some shortcuts
are also provided, e.g. \code{x[["u1"]]} retrieves \code{v[,1]}, and similarly
for the other velocity components. The \code{a} and \code{q}
data can be retrieved in \code{\link{raw}} form or numeric
form (see examples). The coordinate system may be
retrieved with e.g. \code{x[["coordinate"]]}.}
\usage{
\S4method{[[}{adp}(x, i, j, ...)
}
\arguments{
\item{x}{An \code{adp} object, i.e. one inheriting from \code{\link{adp-class}}.}

\item{i}{Character string indicating the name of item to extract.}

\item{j}{Optional additional information on the \code{i} item.}

\item{...}{Optional additional information (ignored).}
}
\description{
The \code{[[} method works for all \code{oce} objects, i.e.
objects inheriting from \code{\link{oce-class}}.  The purpose,
as with the related replacement method, \code{\link{[[<-}},
is to insulate users from the internal details of \code{oce}
objects, by looking for items within the various storage
slots of the object. Items not actually stored can also be
extracted, including derived data, units of measurement,
and data-quality flags.

The method uses a two-step process to try to find the
requested information. First, a class-specific function
is used to try to access the requested information (see
\dQuote{Details of the specialized ... method}).
Second, if no match is found, a general function is used
(see \sQuote{Details of the general method}). If neither
method can locates the requested item, \code{NULL} is returned.
}
\section{Details of the general method}{


If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges
first on the value of \code{i}.

First, a check is made as to whether \code{i} names one of the standard
\code{oce} slots, and returns the slot contents if so. Thus,
\code{x[["metadata"]]} will retrieve the \code{metadata} slot,
while \code{x[["data"]]} and \code{x[["processingLog"]]} return
those slots.

Next, if \code{i} is a string ending in the
\code{"Unit"}, then the characters preceding that string
are taken to be the name of an item in the data object, and a list
containing the unit is returned. This list consists of an item
named \code{unit}, which is an \code{\link{expression}}, and
an item named \code{scale}, which is a string describing the
measurement scale.  If the string ends in \code{" unit"}, e.g.
\code{x[["temperature unit"]]}, then just the expression is returned,
and if it ends in \code{" scale"}, then just the scale is returned.

Next, if \code{i} is a string ending in \code{"Flag"}, then the corresponding
data-quality flag is returned (or \code{NULL} if there is no such flag).
For example, \code{x[["salinityFlag"]]} returns a vector of salinity
flags if \code{x} is a ctd object.

If none of the preceding conditions are met, a check is done
to see if the \code{metadata} slot contains an item with
the provided name, and that is returned, if so. A direct match
is required for this condition.

Finally, the \code{data} slot is checked to see if it contains
an item with the name indicated by \code{i}. In this case, a partial
match will work; this is accomplished by using \code{\link{pmatch}}.

If none of the above-listed conditions holds, then \code{NULL} is returned.
}

\examples{
data(adp)
# Tests for beam 1, distance bin 1, first 5 observation times
adp[["v"]][1:5,1,1]
adp[["a"]][1:5,1,1]
adp[["a", "numeric"]][1:5,1,1]
as.numeric(adp[["a"]][1:5,1,1]) # same as above

}
\seealso{
Other functions that extract parts of \code{oce} objects: \code{\link{[[,adv-method}},
  \code{\link{[[,amsr-method}},
  \code{\link{[[,argo-method}},
  \code{\link{[[,bremen-method}},
  \code{\link{[[,cm-method}},
  \code{\link{[[,coastline-method}},
  \code{\link{[[,ctd-method}},
  \code{\link{[[,echosounder-method}},
  \code{\link{[[,g1sst-method}},
  \code{\link{[[,gps-method}},
  \code{\link{[[,ladp-method}},
  \code{\link{[[,lisst-method}},
  \code{\link{[[,lobo-method}},
  \code{\link{[[,met-method}}, \code{\link{[[,odf-method}},
  \code{\link{[[,rsk-method}},
  \code{\link{[[,sealevel-method}},
  \code{\link{[[,section-method}},
  \code{\link{[[,tidem-method}},
  \code{\link{[[,topo-method}},
  \code{\link{[[,windrose-method}},
  \code{\link{[[<-,adv-method}}

Other things related to \code{adp} data: \code{\link{[[<-,adp-method}},
  \code{\link{adp-class}},
  \code{\link{adpEnsembleAverage}}, \code{\link{adp}},
  \code{\link{as.adp}}, \code{\link{beamName}},
  \code{\link{beamToXyzAdp}}, \code{\link{beamToXyzAdv}},
  \code{\link{beamToXyz}}, \code{\link{beamUnspreadAdp}},
  \code{\link{binmapAdp}}, \code{\link{enuToOtherAdp}},
  \code{\link{enuToOther}}, \code{\link{plot,adp-method}},
  \code{\link{read.ad2cp}}, \code{\link{read.adp.nortek}},
  \code{\link{read.adp.rdi}},
  \code{\link{read.adp.sontek.serial}},
  \code{\link{read.adp.sontek}}, \code{\link{read.adp}},
  \code{\link{read.aquadoppHR}},
  \code{\link{read.aquadoppProfiler}},
  \code{\link{read.aquadopp}},
  \code{\link{subset,adp-method}},
  \code{\link{summary,adp-method}}, \code{\link{toEnuAdp}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdp}}, \code{\link{xyzToEnu}}
}
\author{
Dan Kelley
}
