% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{lowpass}
\alias{lowpass}
\title{Perform lowpass digital filtering}
\usage{
lowpass(x, filter = "hamming", n, replace = TRUE, coefficients = FALSE)
}
\arguments{
\item{x}{a vector to be smoothed}

\item{filter}{name of filter; at present, \code{"hamming"}, \code{"hanning"}, and \code{"boxcar"} are permitted.}

\item{n}{length of filter (must be an odd integer exceeding 1)}

\item{replace}{a logical value indicating whether points near the
ends of \code{x} should be copied into the end regions, replacing
the \code{NA} values that would otherwise be placed there by
\link[stats]{filter}.}

\item{coefficients}{logical value indicating whether to return
the filter coefficients, instead of the filtered values. In accordance
with conventions in the literature, the returned values are not
normalized to sum to 1, although of course that normalization
is done in the actual filtering.}
}
\value{
By default, \code{lowpass} returns a filtered version
of \code{x}, but if \code{coefficients} is \code{TRUE} then it
returns the filter coefficients.
}
\description{
The filter coefficients are constructed using standard definitions,
and then \link[stats]{filter} in the \pkg{stats} package is
used to filter the data. This leaves \code{NA}
values within half the filter length of the ends of the time series, but
these may be replaced with the original \code{x} values, if the argument
\code{replace} is set to \code{TRUE}.
}
\section{Caution}{
 This function was added in June of 2017,
and it may be extended during the rest of 2017. New arguments
may appear between \code{n} and \code{replace}, so users are
advised to call this function with named arguments, not positional
arguments.
}

\examples{

library(oce)
par(mfrow=c(1, 2), mar=c(4, 4, 1, 1))
coef <- lowpass(n=5, coefficients=TRUE)
plot(-2:2, coef, ylim=c(0, 1), xlab="Lag", ylab="Coefficient")
x <- seq(-5, 5) + rnorm(11)
plot(1:11, x, type='o', xlab="time", ylab="x and X")
X <- lowpass(x, n=5)
lines(1:11, X, col=2)
points(1:11, X, col=2)
}
\author{
Dan Kelley
}
