% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bremen.R
\docType{class}
\name{bremen-class}
\alias{bremen-class}
\title{Class for data stored in a format used at Bremen}
\description{
Class for data stored in a format used at Bremen. This is somewhat unusual
amongst \code{oce} classes, in that it does not map to a particular
instrument. Although some functions are provided for dealing with these
data (see \dQuote{Details}), the most common action is to read the
data with \code{\link{read.bremen}}, and then to coerce the object to
another storage class (e.g. using \code{\link{as.ctd}} for CTD-style
data) so that specialized functions can be used thereafter.

The main function is \code{\link{read.bremen}}.  A simple
plotting method is provided with \code{\link{plot,bremen-method}}, and
\code{\link{summary,bremen-method}} provides summaries. Data may be
retrieved with \code{\link{[[,bremen-method}} or replaced with
\code{\link{[[<-,bremen-method}}.
}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{cm-class}}, \code{\link{coastline-class}},
  \code{\link{ctd-class}}, \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{odf-class}}, \code{\link{rsk-class}},
  \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{bremen} data: \code{\link{[[,bremen-method}},
  \code{\link{[[<-,bremen-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{read.bremen}},
  \code{\link{summary,bremen-method}}
}
\author{
Dan Kelley
}
