% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladp.R
\docType{methods}
\name{plot,ladp-method}
\alias{plot,ladp-method}
\title{Plot an ladp object}
\usage{
\S4method{plot}{ladp}(x, which = c("u", "v"), ...)
}
\arguments{
\item{x}{A \code{ladp} object, e.g. as read by \code{\link{as.ladp}}.}

\item{which}{Vector of names of items to be plotted.}

\item{...}{Other arguments, passed to plotting functions.}
}
\description{
Uses \code{\link{plotProfile}} to create panels of depth variation of easterly
and northerly velocity components.
}
\author{
Dan Kelley
}
\seealso{
Other functions that plot \code{oce} data: \code{\link{plot,adp-method}},
  \code{\link{plot,adv-method}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,argo-method}},
  \code{\link{plot,bremen-method}},
  \code{\link{plot,cm-method}},
  \code{\link{plot,coastline-method}},
  \code{\link{plot,ctd-method}},
  \code{\link{plot,gps-method}},
  \code{\link{plot,lisst-method}},
  \code{\link{plot,lobo-method}},
  \code{\link{plot,met-method}},
  \code{\link{plot,odf-method}},
  \code{\link{plot,rsk-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{plot,sealevel-method}},
  \code{\link{plot,section-method}},
  \code{\link{plot,tidem-method}},
  \code{\link{plot,topo-method}},
  \code{\link{plot,windrose-method}},
  \code{\link{plotProfile}}, \code{\link{plotScan}},
  \code{\link{plotTS}}, \code{\link{tidem-class}}

Other things related to \code{ladp} data: \code{\link{[[,ladp-method}},
  \code{\link{as.ladp}}, \code{\link{ladp-class}},
  \code{\link{summary,ladp-method}}
}

