% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{detrend}
\alias{detrend}
\title{Detrend a set of observations}
\usage{
detrend(x, y)
}
\arguments{
\item{x}{a vector of numerical values.  If \code{y} is not given, then
\code{x} is taken for \code{y}.}

\item{y}{an optional vector}
}
\value{
A list containing \code{Y}, the detrended version of \code{y}, and
the intercept \code{a} and slope \code{b} of the linear function of \code{x}
that is subtracted from \code{y} to yield \code{Y}.
}
\description{
Detrends \code{y} by subtracting a linear trend in \code{x}, to create
a vector that is zero for its first and last finite value.
If the second parameter (\code{y}) is missing, then \code{x} is
taken to be \code{y}, and a new \code{x} is constructed with
\code{\link{seq_along}}.  Any \code{NA} values are left as-is.
}
\details{
A common application is to bring the end points of a time series
down to zero, prior to applying a digital filter. (See examples.)
}
\examples{

x <- seq(0, 0.9 * pi, length.out=50)
y <- sin(x)
y[1] <- NA
y[10] <- NA
plot(x, y, ylim=c(0,1))
d <- detrend(x, y)
points(x, d$Y, pch=20)
abline(d$a, d$b, col='blue')
abline(h=0)
points(x, d$Y + d$a + d$b * x, col='blue', pch='+')
}
\author{
Dan Kelley
}

