% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\name{read.coastline.openstreetmap}
\alias{read.coastline.openstreetmap}
\title{Read a Coastline File in Openstreetmap Format}
\usage{
read.coastline.openstreetmap(file, lonlim = c(-180, 180), latlim = c(-90,
  90), debug = getOption("oceDebug"), monitor = FALSE, processingLog)
}
\arguments{
\item{file}{name of file containing coastline data.}

\item{lonlim}{as \code{latlim}, but a signed longitude.}

\item{latlim}{range of (signed) latitudes, used only for shapefiles.
Regions that do not intersect this range are skipped.}

\item{debug}{set to TRUE to print information about the header, etc.}

\item{monitor}{Logical indicating whether to print an indication of progress through
the file.}

\item{processingLog}{if provided, the action item to be stored in the log.
(Typically only provided for internal calls; the default that it provides is
better for normal calls by a user.)}
}
\value{
An object of \code{\link{coastline-class}}
}
\description{
Read coastline data stored in the openstreetmap format [1].
}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{coastline} data: \code{\link{[[,coastline-method}},
  \code{\link{[[<-,coastline-method}},
  \code{\link{as.coastline}},
  \code{\link{coastline-class}},
  \code{\link{coastlineBest}}, \code{\link{coastlineCut}},
  \code{\link{coastlineWorld}},
  \code{\link{plot,coastline-method}},
  \code{\link{read.coastline.shapefile}},
  \code{\link{subset,coastline-method}},
  \code{\link{summary,coastline-method}}
}

