% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\docType{methods}
\name{plot,amsr-method}
\alias{plot,amsr-method}
\alias{plot.amsr}
\title{Plot an amsr Object}
\usage{
\S4method{plot}{amsr}(x, y, asp, debug = getOption("oceDebug"), ...)
}
\arguments{
\item{x}{An object inherting from \code{\link{amsr-class}}.}

\item{y}{String indicating the name of the band to plot; if not provided,
\code{SST} is used; see \code{\link{amsr-class}} for a list of bands.}

\item{asp}{Optional aspect ratio for plot.}

\item{debug}{A debugging flag, integer.}

\item{...}{extra arguments passed to \code{\link{imagep}}, e.g. set
\code{col} to control colours.}
}
\description{
Plot an amsr Object
}
\examples{
\dontrun{
d <- read.amsr("f34_20160102v7.2.gz")
asp <- 1/cos(pi*40/180)
plot(d, "SST", col=oceColorsJet, xlim=c(-80,0), ylim=c(20,60), asp=asp)
data(coastlineWorldMedium, package="ocedata")
lines(coastlineWorldMedium[['longitude']], coastlineWorldMedium[['latitude']])
}

}
\author{
Dan Kelley
}
\seealso{
Other functions dealing with satellite data: \code{\link{[[,landsat-method}},
  \code{\link{amsr-class}}, \code{\link{g1sst-class}},
  \code{\link{landsatAdd}}, \code{\link{landsatTrim}},
  \code{\link{plot,landsat-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{read.amsr}}, \code{\link{read.g1sst}},
  \code{\link{read.landsat}},
  \code{\link{satellite-class}},
  \code{\link{summary,amsr-method}},
  \code{\link{summary,landsat-method}},
  \code{\link{summary,satellite-method}}
}
\concept{
satellite
}

