% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocd.R
\name{getData}
\alias{getData}
\alias{getData.OCD}
\alias{getData.Mei}
\alias{getData.XS}
\alias{getData.Chan}
\title{Processing a new data point}
\usage{
getData(detector, x_new)

\method{getData}{OCD}(detector, x_new)

\method{getData}{Mei}(detector, x_new)

\method{getData}{XS}(detector, x_new)

\method{getData}{Chan}(detector, x_new)
}
\arguments{
\item{detector}{Object of class 'Changepoint Detector'}

\item{x_new}{A new data point. It must be of the same dimension as
specified in the data_dim attribute of \code{detector}.}
}
\value{
Updated object \code{detector}
}
\description{
This is the main function for the 'ChangepointDetector' class.
}
\details{
If the status of the \code{detector} object is 'estimating', the new
data point is used to update the current estimate of pre-change mean.
If the status of the \code{detector} object is 'monitoring', the new
data point is used to detect if a mean change has occurred.
}
\section{Methods (by class)}{
\itemize{
\item \code{OCD}: Process a new data for subclass 'OCD'

\item \code{Mei}: Process a new data for subclass 'Mei'

\item \code{XS}: Process a new data for subclass 'XS'

\item \code{Chan}: Process a new data for subclass 'Chan'
}}

\seealso{
\code{\link{setBaselineMean}} for updating the pre-change mean
estimate, \code{\link{checkChange}} for checking for change.
}
