% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meters_to_decdeg.R
\name{meters_to_decdeg}
\alias{meters_to_decdeg}
\title{Convert from meters to degrees correcting for global position}
\usage{
meters_to_decdeg(
  occs_df,
  lat_col = "latitude",
  lon_col = "longitude",
  distance,
  na_action = "NA as 0"
)
}
\arguments{
\item{occs_df}{A \code{data.frame} of occurrence locations that incudes
\emph{at least these three columns} - latitude, longitude, and a distance
in meters to be converted to decimal degrees.}

\item{lat_col}{Name of column of latitude values. Caps sensitive.}

\item{lon_col}{Name of column of longitude values. Caps sensitive.}

\item{distance}{Name of column of distance values, in meters. Caps sensitive.}

\item{na_action}{Enact distance options for NA values. Caps sensitive}
}
\value{
dist_dd A \code{data.frame} of latitude and longitude distances in
  units of degree decimal.
}
\description{
\code{meters_to_decdeg} converts from meters to degrees at a specified
position on the globe. The use case this function was developed for was to
calculate occurence point uncertainty values, which are usually reported in
meters, as degrees.

The formula for converting from meters to decimal degrees is in part
based on information from the ESRI ArcUser magazine at this site
\url{https://www.esri.com/news/arcuser/0400/wdside.html}
}
