% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trades.R
\name{matchTrades}
\alias{matchTrades}
\title{Construct trades data.table.}
\usage{
matchTrades(events)
}
\arguments{
\item{events}{Limit order event data with assigned maker/taker event ids.}
}
\value{
A data.frame describing marketable order executions of the following
form:
\describe{
  \item{timestamp}{min(maker timestamp, taker timestamp) (first time we
learned of this trade)}
  \item{price}{Maker price (taker limit price can cross the book.)}
  \item{volume}{Lifted/traded volume}
  \item{direction}{Trade direction (side of the aggressor/taker)}
  \item{maker.event.id}{event.id corresponding to row in events data}
  \item{taker.event.id}{event.id corresponding to tow in events data}
  \item{maker}{Maker limit order id}
  \item{taker}{Taker limit order id}
}

A market limit order (marketable) is first a taker and then becomes a maker
after landing in the order book before it's limit is reached.

A market order is always a taker: it's volume will be filled before it's
limit is reached.

Grouping executions by maker/taker can be used to analyse market impact
events.
}
\description{
Given event data which has been pre-matched with maker/taker event ids,
this function will return a data.table containing all matched executions.
}
\examples{
\dontrun{

csv.file <- system.file("extdata", "orders.csv.xz", package="obAnalytics")
events <- loadEventData(csv.file)
events <- eventMatch(events)
trades <- matchTrades(events)
}
}
\author{
phil
}
\keyword{internal}

