\name{plot.oaxaca}
\alias{plot.oaxaca}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Coefficient Bar Plots for the Blinder-Oaxaca Decomposition
%%  ~~function to do ... ~~
}
\description{
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
\code{plot.oaxaca} is used to generate a set of coefficient bar plots that present the results of a Blinder-Oaxaca decomposition graphically.}
\usage{
\method{plot}{oaxaca}(x, decomposition = "threefold", type = "variables", weight = NULL,
     unexplained.split = FALSE, variables = NULL, components = NULL,
     component.left = FALSE, component.labels = NULL, variable.labels = NULL,
     ci = TRUE, ci.level = 0.95, 
     title = "", xlab = "", ylab = "", bar.color = NULL, ...) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{an object of class \code{"oaxaca"}, typically generated by the \code{\link{oaxaca}} function.}
  \item{decomposition}{specifies which type of decomposition will be presented. Can be either \code{"threefold"} (default) or \code{"twofold"}.}
  \item{type}{specifies whether the results of an overall decomposition or a variable-by-variable decomposition will be presented. Can be either \code{"variables"} (default) or \code{"overall"}.}
  \item{weight}{a numeric value that specifies the weight for which the twofold decomposition results will be presented. Only relevant when argument \code{decomposition} is set to \code{"twofold"}.}
  \item{unexplained.split}{a logical value that toggles whether, in the twofold decomposition, the presentation of the \code{unexplained} component will be split into the \code{unexplained A} and \code{unexplained B} parts. See \code{\link{oaxaca}} for details.}
  \item{variables}{a character vector that specifies the variables for which coefficient bar plots are requested. If NULL, plots for all variables will be produced. Only relevant when argument \code{type} is set to \code{"variables"}. This argument can also be used to determine the order in which variables are presented.}
  \item{components}{a character vector that specifies which decomposition components will be presented. For threefold decomposition, must be a subset of \code{"endowments"}, \code{"coefficients"} and \code{"interaction"}. For twofold decomposition, must be a subset of \code{"explained"}, \code{"unexplained"} and - if argument \code{unexplained.split} is set to \code{TRUE} - \code{"unexplained A"} and \code{"unexplained B"}. This argument can also be used to determine the order in which decomposition components are presented.}
  \item{component.left}{a logical value that specifies whether the decomposition components will be presented along the left side of the coefficient bar plot. By default, the argument is set to \code{FALSE}, and the left side of the plot lists individual variables. Only relevant when argument \code{type} is set to \code{"variables"}.}
  \item{component.labels}{a named character vector that specifies custom labels for individual decomposition components. The character vector elements contain the new labels, while the elements' names must correspond to the appropriate decomposition components: \code{"endowments"}, \code{"coefficients"}, \code{"interaction"}, \code{"explained"}, \code{"unexplained"}, \code{"unexplained A"}, \code{"unexplained B"}. }
  \item{variable.labels}{a named character vector that specifies custom labels for the presented variables. The character vector elements contain the new labels, while the elements' names must contain the appropriate variable name. Only relevant when argument \code{type} is set to \code{"variables"}.}
  \item{ci}{a logical value that toggles the presentation of confidence intervals (standard error bars) in the coefficient bar plots.}
  \item{ci.level}{a numeric value between 0 and 1 that specifies the confidence level for the presented confidence intervals.}
  \item{title}{a character string that contains the title of the coefficient bar plot.}
  \item{xlab}{a character string that specifies the horizontal axis label.}
  \item{ylab}{a character string that specifies the vertical axis label.}
  \item{bar.color}{a named vector that specifies the color of bars in the plot. The vector elements' names contain a string that identifies either the variable or the decomposition component that the color will be applied to. If no names are specifies, the bars will be colored from top to bottom.}
  \item{...}{additional arguments passed on to the aesthetic mapping (\code{aes}) of the \code{ggplot} function (Wickham, 2009) used to generate the coefficient bar plots inside the method.}
}
\references{
Wickham, Hadley. (2009). ggplot2: Elegant Graphics for Data Analysis. Springer Science & Business Media.
}
\author{
%%  ~~who you are~~
Marek Hlavac   < hlavac at fas.harvard.edu > \cr
Harvard University, Political Economy and Government \cr
}
\section{Please cite as:}{
Hlavac, Marek (2016). oaxaca: Blinder-Oaxaca Decomposition in R.\cr
R package version 0.1.3. http://CRAN.R-project.org/package=oaxaca 
}
\seealso{
\code{\link{oaxaca}}
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
# set random seed
set.seed(08544)

# load data set of Hispanic workers in Chicago
data("chicago")

# perform Blinder-Oaxaca Decomposition:
# explain differences in log real wages across native and foreign-born groups
oaxaca.results <- oaxaca(ln.real.wage ~ age + female + LTHS + some.college + 
                                          college + advanced.degree | foreign.born, 
                         data = chicago, R = 50)

# plot results of the threefold decomposition, variable-by-variable
# only include educational variables
# decomposition components along the left side of the plot
plot(oaxaca.results, component.left = TRUE,
     variables = c("LTHS", "some.college", "college", "advanced.degree"),
     variable.labels = c("LTHS" = "less than high school", 
                         "some.college" = "some college",
                         "advanced.degree" = "advanced degree"))
                         
# plot results of the twofold decomposition (overall results)
# equal weight for Group A and B in reference coefficient determinantion (weight = 0.5)
# unexplained portion split into A and B
plot(oaxaca.results, decomposition = "twofold", type = "overall",
     weight = 0.5, unexplained.split = TRUE, 
     bar.color = c("limegreen", "hotpink", "steelblue"))

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
}
\keyword{ models }
\keyword{ regression }
\keyword{ nonlinear }
\keyword{ robust }
\keyword{ multivariate }

