% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oXim-internal.R, R/oXim-main.R,
%   R/oxyclineData-class.R
\name{echogramPlot.default}
\alias{echogramPlot.default}
\alias{echogramPlot}
\alias{echogramPlot.matrix}
\title{Plot a matrix of a filtered echogram.}
\usage{
\method{echogramPlot}{default}(x, colEchogram = "colPalette", ...)

echogramPlot(x, colEchogram = "colPalette", ...)

\method{echogramPlot}{matrix}(x, ...)
}
\arguments{
\item{x}{Object of class \code{oxyclineData}, \code{echoData} or \code{matrix} with information for make
an echogram plot. If \code{x} is a \code{matrix}, column names must indicate the time and row names, the
depth.}

\item{colEchogram}{Pallete of colours to plot the echograms. If \code{NULL} (default) the system
will use the same combination used on object \code{colPallete}.}

\item{...}{Extra arguments passed to \code{\link{echogramPlot}} function.}
}
\description{
This function takes an echogram matrix and plot it.
}
\details{
Typically, `echogramPlot` can be applied to echogram matrix object, however it also may use
`echoData` and `oxyclineData` objects, as a method.
}
\examples{
fileMode <- list(fish38_file   = system.file("extdata", "fish38.mat", package = "oXim"),
                 fluid120_file = system.file("extdata", "fluid120.mat", package = "oXim"),
                 blue38_file   = system.file("extdata", "blue38.mat", package = "oXim"))
echoData <- readEchograms(fileMode = fileMode)
echogramPlot(x = echoData)
}
