% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oXim-main.R
\name{echogramPlot}
\alias{echogramPlot}
\title{Plot a matrix of a filtered echogram.}
\usage{
echogramPlot(echogramOutput, colEchogram = "colPalette", ...)
}
\arguments{
\item{echogramOutput}{Object of class \code{oxyclineData} with internal echogram matrix to be plotted.}

\item{colEchogram}{Pallete of colours to plot the echograms. If \code{NULL} (default) the system
will use the same combination used on object \code{colPallete}.}

\item{...}{Graphical parameters for \code{\link{image}} may also passed as arguments to this function.}
}
\description{
This function uses an oxyclineData-class object and plot .
}
\examples{
fileMode <- list(fish38_file   = system.file("extdata", "fish38.mat", package = "oXim"),
                 fluid120_file = system.file("extdata", "fluid120.mat", package = "oXim"),
                 blue38_file   = system.file("extdata", "blue38.mat", package = "oXim"))
echoData <- readEchograms(fileMode = fileMode)
echogramPlot(echoData$data$matrix_1$echogram)
}

