% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateTranscript.R
\name{updateTranscript}
\alias{updateTranscript}
\title{Update an existing transcript.}
\usage{
updateTranscript(labbcat.url, transcript.path)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{transcript.path}{The path to the transcript to upload.}
}
\value{
The ID of the updated transcript in the corpus
}
\description{
This function uploads a new version of an existing transcript.
}
\details{
For this function to work, the credentials used to connect to the server must have at
least 'edit' access.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## upload new verison of transcript transcript
updateTranscript(labbcat.url, "my-transcript.eaf")
}
}
\keyword{management}
\keyword{transcript}
