% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuts_classify.R
\name{nuts_classify}
\alias{nuts_classify}
\title{Classify version of NUTS codes}
\usage{
nuts_classify(
  data,
  nuts_code,
  group_vars = NULL,
  ties = c("most_recent", "oldest")
)
}
\arguments{
\item{data}{A data frame or tibble that contains a variable with NUTS \code{1}, \code{2} or \code{3} codes and possibly other variables.
NUTS codes must be of the same level and need to be unique, unless additional grouping variables are specified. No
duplicate NUTS codes within groups allowed.}

\item{nuts_code}{Variable name containing NUTS codes}

\item{group_vars}{Variable name(s) for classification within groups. \code{nuts_classify()} always computes overlap within country. Hence, country variables should not be specified. \code{NULL} by default.}

\item{ties}{Picks \code{'most_recent'} or \code{'oldest'} version when overlap is identical across multiple NUTS versions. \code{'most_recent'}
by default.}
}
\value{
A list of three tibbles. The first tibble contains the original data with the classified NUTS version, level, and country.
The second tibble lists the group-specific overlap with each NUTS version. The third tibble shows missing NUTS codes
for each group.

The output can be passed to \code{\link[=nuts_convert_version]{nuts_convert_version()}} to convert data across NUTS versions and \code{\link[=nuts_aggregate]{nuts_aggregate()}} to aggregate across NUTS levels.
}
\description{
\code{nuts_classify()} can identify the NUTS version year and level from a variable containing NUTS codes.
}
\details{
Console messages can be controlled with \code{rlang::local_options(nuts.verbose = "quiet")} to silence messages and
\code{nuts.verbose = "verbose"} to switch messages back on.
}
\examples{
library(dplyr)

# Load EUROSTAT data of manure storage deposits
data(manure)

# Data varies at the NUTS level x indicator x year x country x NUTS code level
head(manure)

# Classify version of NUTS 2 codes in Germany
manure \%>\%
 filter(nchar(geo) == 4) \%>\%
 filter(indic_ag == 'I07A_EQ_Y') \%>\%
 filter(grepl('^DE', geo)) \%>\%
 filter(time == 2003) \%>\%
 select(-indic_ag, -time) \%>\%
 # Data varies at the NUTS code level
 nuts_classify(nuts_code = 'geo')

# Classify version of NUTS 3 codes within country and year
manure \%>\%
  filter(nchar(geo) == 5) \%>\%
  filter(indic_ag == 'I07A_EQ_Y') \%>\%
  select(-indic_ag) \%>\%
  # Data varies at the year x country x NUTS code level. The country grouping
  # is always used by default.
  nuts_classify(nuts_code = 'geo', group_vars = 'time')


}
