% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budget.R
\name{budget}
\alias{budget}
\title{Calorie budget}
\usage{
budget(wt_delta_per_week, bmr)
}
\arguments{
\item{wt_delta_per_week}{expected change in weight per week}

\item{bmr}{Basal Metabolic Rate, in kilocalories}
}
\value{
Calorie targets per day
}
\description{
Calculates a calorie budget
}
\examples{
BMR <- bmr(66, 40, .12, 178, method = "kma")
budget(0, BMR) # for weight maintenance with a weekend bonus
budget(.25, BMR) # for a slight weight gain
}
\references{
https://help.loseit.com/hc/en-us/articles/115007245847-How-the-Calorie-Budget-is-Calculated
}
\author{
Waldir Leoncio
}
