% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gpr1sample}
\alias{gpr1sample}
\title{Perform one-sample GP regression}
\usage{
gpr1sample(x, y, x.targets, noise = NULL, nsnoise = TRUE, nskernel = TRUE,
  expectedmll = FALSE, params = NULL, defaultparams = NULL,
  lbounds = NULL, ubounds = NULL, optim.restarts = 3,
  derivatives = FALSE)
}
\arguments{
\item{x}{input points}

\item{y}{output values (same length as \code{x})}

\item{x.targets}{target points}

\item{noise}{observational noise (variance), either NULL, a constant scalar or a vector}

\item{nsnoise}{estimate non-stationary noise from replicates, if possible (default)}

\item{nskernel}{use non-stationary kernel}

\item{expectedmll}{use an alternative expected mll optimization criteria}

\item{params}{gaussian kernel parameters: \code{(sigma.f, sigma.n, l, lmin, c)}}

\item{defaultparams}{initial parameters for optimization (5-length vector)}

\item{lbounds}{lower bounds for parameters (5-length vector)}

\item{ubounds}{upper bounds for parameters (5-length vector)}

\item{optim.restarts}{restarts in the gradient ascent (default=3)}

\item{derivatives}{compute also GP derivatives}
}
\value{
A \code{gp}-object (list) containing following elements
 \item{targets}{data frame of predictions with points as rows and columns..}
 \item{_$x}{points}
 \item{_$pmean}{posterior mean of the gp}
 \item{_$pstd}{posterior standard deviation of the gp}
 \item{_$noisestd}{noises (variance)}
 \item{_$mll}{the MLL log likelihood ratio }
 \item{_$emll}{the EMLL log likelihood ratio}
 \item{_$pc}{the posterior concentration log likelihood ratio}
 \item{_$npc}{the noisy posterior concentration log likelihood ratio}
 \item{cov}{learned covariance matrix}
 \item{mll}{marginal log likelihood value}
 \item{emll}{expected marginal log likelihood value}
 \item{kernel}{the kernel matrix used}
 \item{ekernel}{the EMLL kernel matrix}
 \item{params}{the learned parameter vector:}
 \item{_$sigma.f}{kernel variance}
 \item{_$sigma.n}{kernel noise}
 \item{_$l}{maximum lengthscale}
 \item{_$lmin}{minimum lengthscale}
 \item{_$c}{curvature}
 \item{x}{the input points}
 \item{y}{the output values}
}
\description{
Computes the optimal GP model by optimizing the marginal likelihood
}
\details{
Parameter optimization performed through L-BFGS using analytical gradients
 with restarts. The input points \code{x} and output values {y} need to be matching
  length vectors. If replicates are provided, they are used to estimate dynamic
  observational noise.

 The resulting GP model is encapsulated in the return object. The estimated posterior
  is in \code{targets$pmean} and \code{targets$pstd} for target points \code{x.targets}.
   Use \code{\link{plot.gp}} to visualize the GP.
}
\examples{
# load example data
data(toydata)

\dontrun{can take sevaral minutes
 # perform gpr
 res = gpr1sample(toydata$ctrl$x, toydata$ctrl$y, seq(0,22,0.1))
 print(res)}

# pre-computed toydata model
data(toygps)
print(toygps$ctrlmodel)
}
\seealso{
\code{\link{gpr2sample}} \code{\link{plot.gp}}
}

