% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterKinMatrix.R
\name{filterKinMatrix}
\alias{filterKinMatrix}
\title{Filters a kinship matrix to include only the egos listed in 'ids'}
\usage{
filterKinMatrix(ids, kmat)
}
\arguments{
\item{ids}{character vector containing the IDs of interest.
The kinship matrix should be reduced to only include these rows and columns.}

\item{kmat}{a numeric matrix of pairwise kinship coefficients.
Rows and columns should be named with IDs.}
}
\value{
A numeric matrix that is the reduced kinship matrix with named
rows and columns (row and col names are 'ids').
}
\description{
Filters a kinship matrix to include only the egos listed in 'ids'
}
\examples{
library(nprcgenekeepr)
ped <- nprcgenekeepr::qcPed
ped$gen <- findGeneration(ped$id, ped$sire, ped$dam)
kmat <- kinship(ped$id, ped$sire, ped$dam, ped$gen,
  sparse = FALSE
)
ids <- ped$id[c(189, 192, 194, 195)]
ncol(kmat)
nrow(kmat)
kmatFiltered <- filterKinMatrix(ids, kmat)
ncol(kmatFiltered)
nrow(kmatFiltered)
}
