% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcRetention.R
\name{calcRetention}
\alias{calcRetention}
\title{Calculates Allelic Retention}
\usage{
calcRetention(ped, alleles)
}
\arguments{
\item{ped}{the pedigree information in datatable format.  Pedigree
(req. fields: id, sire, dam, gen, population).

It is assumed that the pedigree has no partial parentage}

\item{alleles}{dataframe of containing an \code{AlleleTable}. This is a
table of allele information produced by \code{geneDrop()}.}
}
\value{
A vector of the mean number of founder alleles retained in the
gene dropping simulation.
}
\description{
Part of Genetic Value Analysis
}
\examples{
library(nprcgenekeepr)
data("lacy1989Ped")
data("lacy1989PedAlleles")
ped <- lacy1989Ped
alleles <- lacy1989PedAlleles
retention <- calcRetention(ped, alleles)
}
