% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addUIds.R
\name{addUIds}
\alias{addUIds}
\title{Eliminates partial parentage situations by adding unique placeholder
IDs for the unknown parent.}
\usage{
addUIds(ped)
}
\arguments{
\item{ped}{datatable that is the \code{Pedigree}. It contains pedigree
information. The fields \code{sire} and \code{dam} are required.}
}
\value{
The updated pedigree with partial parentage removed.
}
\description{
This must be run prior to \code{addParents} since the IDs made herein are
used by \code{addParents}
}
\examples{
pedTwo <- data.frame(
  id = c("s1", "d1", "s2", "d2", "o1", "o2", "o3", "o4"),
  sire = c(NA, "s0", "s4", NA, "s1", "s1", "s2", "s2"),
  dam = c("d0", "d0", "d4", NA, "d1", "d2", "d2", "d2"),
  sex = c("M", "F", "M", "F", "F", "F", "F", "M"),
  stringsAsFactors = FALSE
)
newPed <- addUIds(pedTwo)
newPed[newPed$id == "s1", ]
pedThree <-
  data.frame(
    id = c("s1", "d1", "s2", "d2", "o1", "o2", "o3", "o4"),
    sire = c("s0", "s0", "s4", NA, "s1", "s1", "s2", "s2"),
    dam = c(NA, "d0", "d4", NA, "d1", "d2", "d2", "d2"),
    sex = c("M", "F", "M", "F", "F", "F", "F", "M"),
    stringsAsFactors = FALSE
  )
newPed <- addUIds(pedThree)
newPed[newPed$id == "s1", ]
}
