% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/withinIntegerRange.R
\name{withinIntegerRange}
\alias{withinIntegerRange}
\title{Get integer within a range}
\usage{
withinIntegerRange(int = 0, minimum = 0, maximum = 0, na = "min")
}
\arguments{
\item{int}{value to be forced within a range}

\item{minimum}{minimum integer value.}

\item{maximum}{maximum integer value}

\item{na}{if "min" then non-numerics are forced to the minimum in the range
If "max" then non-numerics are forced to the maximum in the range.
If not either "min" or "max" it is forced to "min".}
}
\value{
A vector of integers forced to be within the specified range.
}
\description{
Assures that what is returned is an integer within the specified range.
Real values are truncated. Non-numerics are forced to minimum without
warning.
}
\examples{
\donttest{
library(nprcgenekeepr)
withinIntegerRange()
withinIntegerRange( , 0, 10)
withinIntegerRange(NA, 0, 10, na = "max")
withinIntegerRange( , 0, 10, na = "max") # no argument is not NA
withinIntegerRange(LETTERS, 0, 10)
withinIntegerRange(2.6, 1, 5)
withinIntegerRange(2.6, 0, 2)
withinIntegerRange(c(0, 2.6, -1), 0, 2)
withinIntegerRange(c(0, 2.6, -1, NA), 0, 2)
withinIntegerRange(c(0, 2.6, -1, NA), 0, 2, na = "max")
withinIntegerRange(c(0, 2.6, -1, NA), 0, 2, na = "min")
}

}
