% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removePotentialSires.R
\name{removePotentialSires}
\alias{removePotentialSires}
\title{Removes potential sires from list of Ids}
\usage{
removePotentialSires(ids, minAge, ped)
}
\arguments{
\item{ids}{character vector of IDs of the animals}

\item{minAge}{integer value indicating the minimum age to consider in group
formation. Pairwise kinships involving an animal of this age or younger will
 be ignored. Default is 1 year.}

\item{ped}{dataframe that is the `Pedigree`. It contains pedigree
information including the IDs listed in \code{candidates}.}
}
\description{
@return character vector of Ids with any potential sire Ids removed.
}
\examples{
\donttest{
library(nprcgenekeepr)
qcBreeders <- nprcgenekeepr::qcBreeders
pedWithGenotype <- nprcgenekeepr::pedWithGenotype
noSires <- removePotentialSires(ids = qcBreeders, minAge = 2,
                                ped = pedWithGenotype)
sires <- getPotentialSires(qcBreeders, minAge = 2, ped = pedWithGenotype)
pedWithGenotype[pedWithGenotype$id \%in\% noSires, c("sex", "age")]
pedWithGenotype[pedWithGenotype$id \%in\% sires, c("sex", "age")]
}

}
