% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countFirstOrder.R
\name{countFirstOrder}
\alias{countFirstOrder}
\title{Count first-order relatives.}
\usage{
countFirstOrder(ped, ids = NULL)
}
\arguments{
\item{ped}{: `Pedigree`
Standardized pedigree information in a table.}

\item{ids}{character vector of IDs or NULL
These are the IDs to which the analysis should be restricted. First-order
relationships will only be tallied for the listed IDs and will only
consider relationships within the subset. If NULL, the analysis will
include all IDs in the pedigree.}
}
\value{
A dataframe with column \code{id}, \code{parents}, \code{offspring},
\code{siblings}, and \code{total}. A table of first-order relationship
counts, broken down to indicate the number of parents, offspring, and
siblings that are part of the subset under consideration.
}
\description{
Part of Relations
}
\details{
Tallies the number of first-order relatives for each member of the provided
pedigree. If 'ids' is provided, the analysis is restricted to only the
specified subset.
}
\examples{
\donttest{
library(nprcgenekeepr)
ped <- nprcgenekeepr::lacy1989Ped
ids <- c("B", "D", "E", "F", "G")
countIds <- countFirstOrder(ped, ids)
countIds
count <- countFirstOrder(ped, NULL)
count
}

}
