% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertAncestry.R
\name{convertAncestry}
\alias{convertAncestry}
\title{Converts the ancestry information to a standardized code}
\usage{
convertAncestry(ancestry)
}
\arguments{
\item{ancestry}{character vector or NA with free-form text providing
information about the geographic population of origin.}
}
\value{
A factor vector of standardized designators specifying if an animal
is a Chinese rhesus, Indian rhesus, Chinese-Indian hybrid rhesus, or
Japanese macaque. Levels: CHINESE, INDIAN, HYBRID, JAPANESE, OTHER, UNKNOWN.
}
\description{
Part of Pedigree Curation
}
\examples{
\donttest{
original <- c("china", "india", "hybridized", NA, "human", "gorilla")
convertAncestry(original)
}

}
