% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseDate.R
\name{chooseDate}
\alias{chooseDate}
\title{Choose date based on \code{earlier} flag.}
\usage{
chooseDate(d1, d2, earlier = TRUE)
}
\arguments{
\item{d1}{\code{Date} vector with the first of two dates to compare.}

\item{d2}{\code{Date} vector with the second of two dates to compare.}

\item{earlier}{logical variable with \code{TRUE} if the earlier of the two
dates is to be returned, otherwise the later is returned. Default is
\code{TRUE}.}
}
\value{
\code{Date} vector of chosen dates or \code{NA} where neither
is provided
}
\description{
Part of Pedigree Curation
}
\details{
Given two dates, one is selected to be returned based on whether
it occurred earlier or later than the other. \code{NAs} are ignored if
possible.
}
\examples{
\donttest{
library(nprcgenekeepr)
someDates <- lubridate::mdy(paste0(sample(1:12, 2, replace = TRUE), "-",
                                   sample(1:28, 2, replace = TRUE), "-",
                                   sample(seq(0, 15, by = 3), 2,
                                          replace = TRUE) + 2000))
someDates
chooseDate(someDates[1], someDates[2], earlier = TRUE)
chooseDate(someDates[1], someDates[2], earlier = FALSE)
}

}
