% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBackSecondParents.R
\name{addBackSecondParents}
\alias{addBackSecondParents}
\title{Add back single parents trimmed pedigree}
\usage{
addBackSecondParents(uPed, ped)
}
\arguments{
\item{uPed}{a trimmed pedigree dataframe with uninformative founders removed.}

\item{ped}{a trimmed pedigree}
}
\value{
A dataframe with pedigree with single parents added.
}
\description{
Uses the \code{ped} dataframe, which has full complement of parents and the
\code{uPed} dataframe, which has all uninformative parents removed to
add back single parents to the \code{uPed} dataframe where one parent is
known. The parents are added back to the pedigree as an ID record with
NA for both sire and dam of the added back ID.
}
\examples{
\donttest{
examplePedigree <- nprcgenekeepr::examplePedigree
breederPed <- qcStudbook(examplePedigree, minParentAge = 2,
                         reportChanges = FALSE,
                         reportErrors = FALSE)
probands <- breederPed$id[!(is.na(breederPed$sire) &
                               is.na(breederPed$dam)) &
                               is.na(breederPed$exit)]
ped <- getProbandPedigree(probands, breederPed)
nrow(ped)
p <- removeUninformativeFounders(ped)
nrow(p)
p <- addBackSecondParents(p, ped)
nrow(p)
}

}
