% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_pgsql.R
\name{replext_pgsql}
\alias{replext_pgsql}
\title{Replext Simulation Shiny App with Database Integration}
\usage{
replext_pgsql(dbname, datatable, host, port, user, password)
}
\arguments{
\item{dbname}{The name of the PostgreSQL database to connect to.}

\item{datatable}{The name of the table in the database where the simulation results will be stored and retrieved.}

\item{host}{The host address of the PostgreSQL database.}

\item{port}{The port number for the PostgreSQL database connection.}

\item{user}{The username for accessing the PostgreSQL database.}

\item{password}{The password for the specified user to access the PostgreSQL database.}
}
\value{
A Shiny app object which can be run to start the application.
}
\description{
This application replicates and extends the simulation results from
the paper by Dwivedi et al. (2017), now with added functionality to
interact with a PostgreSQL database. The app includes a user interface
for selecting simulation parameters and a server logic to process the
simulation and handle user interactions, including saving and retrieving
data from a database.
}
\details{
The app's user interface consists of:
\itemize{
\item A dropdown menu to select a cell block for the simulation, which is
populated using the \code{getCellBlocks} function.
\item Dynamic UI elements for inputting simulation parameters, generated
based on the selected cell block.
\item Buttons to run the simulation and submit the results to a PostgreSQL database.
\item A table to display the simulation results and previously saved responses.
\item A download button to export all responses as a CSV file.
}

The server logic of the app handles:
\itemize{
\item Rendering the dynamic UI elements for simulation parameters.
\item Observing the simulation run event and processing the simulation
using the \code{runSimulation} function.
\item Rendering a table to display the simulation results.
\item Handling the submission of results and storing them in a PostgreSQL database.
\item Loading existing responses from the database.
\item Downloading responses as a CSV file.
}
}
\examples{
if (interactive()) {
  replext_pgsql(
    dbname = "your_db_name",
    datatable = "your_data_table",
    host = "localhost",
    port = 5432,
    user = "your_username",
    password = "your_password"
  )
}

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size studies
using nonparametric bootstrap test with pooled resampling method. Stat Med. 2017
Jun 30;36(14):2187-2205. doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
