% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_dat_scale_alt.R
\name{resample_dat_scale_alt}
\alias{resample_dat_scale_alt}
\title{Title: A function to create an attribute or column for each sample loaded into the microplate wells.}
\usage{
resample_dat_scale_alt(df, tnp, cycles, na_omit = NULL)
}
\arguments{
\item{df}{A clean data frame with attributes or tuples containing a mixture of samples.}

\item{tnp}{A numeric value indicating the number of rows used. TNP is used as an acronym for Test, Negative, Positive.}

\item{cycles}{A numeric value indicating the number of cycles selected by the user when running the FLUOstar instrument.}

\item{na_omit}{Takes a string "yes" OR "no".}
}
\value{
A new data frame where separated samples are assigned a separate attribute or column.
}
\description{
A function that takes tuples or rows consisting of several samples and perform a
putative resampling to yield another data frame with a separate attribute for each
sample.
}
\examples{
fpath <- system.file("extdata", "dat_1.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
resampled_scaled <- resample_dat_scale_alt(nocomma_dat, tnp=3, cycles=40)
}
\seealso{
\code{\link[=resample_dat_alt]{resample_dat_alt()}}
}
\author{
Tingwei Adeck
}
