% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_balance.R
\name{check_balance}
\alias{check_balance}
\title{Checks the variable balance between the probability and non-probability samples}
\usage{
check_balance(x, object, dig)
}
\arguments{
\item{x}{formula specifying variables to check}

\item{object}{object of \code{nonprob} class}

\item{dig}{number of digits for rounding (default = 2)}
}
\value{
A \code{list} containing totals for non-probability and probability samples and their differences
}
\description{
Function compares totals for auxiliary variables specified in the \code{x} argument for an \code{object} that
contains either IPW or DR estimator.
}
\examples{

data(admin)
data(jvs)

jvs_svy <- svydesign(ids = ~ 1,  weights = ~ weight,
strata = ~ size + nace + region, data = jvs)

ipw_est1 <- nonprob(selection = ~ region + private + nace + size,
target = ~ single_shift,
svydesign = jvs_svy,
data = admin, method_selection = "logit"
)

ipw_est2 <- nonprob(
selection = ~ region + private + nace + size,
target = ~ single_shift,
svydesign = jvs_svy,
data = admin, method_selection = "logit",
control_selection = control_sel(est_method = "gee", gee_h_fun = 1))

## check the balance for the standard IPW
check_balance(~size+private, ipw_est1)

## check the balance for the calibrated IPW
check_balance(~size+private, ipw_est2)

## check balance for a more complicated example
check_balance(~ I(size=="M") + I(nace == "C"), ipw_est1)

}
