\name{logisticMap}
\alias{logisticMap}
\title{Logistic map}
\usage{
  logisticMap(r = 4,
    start = runif(n = 1, min = 0, max = 1),
    n.sample = 5000, n.transient = 500, do.plot = TRUE)
}
\arguments{
  \item{start}{A numeric value indicating the starting
  value for the time series. If the starting point is not
  specified, it is generated randomly.}

  \item{r}{The \emph{r} parameter. Default: 4}

  \item{n.sample}{Length of the generated time series.
  Default: 5000 samples.}

  \item{n.transient}{Number of transient samples that will
  be discarded. Default: 500 samples.}

  \item{do.plot}{Logical value. If TRUE (default value), a
  plot of the generated logistic system is shown.}
}
\value{
  A vector containing the values of the time series that
  has been generated.
}
\description{
  Generates a time series using the logistic map.
}
\details{
  The logistic map is defined as follows: \deqn{x_n = r
  \cdot x_{n-1} \cdot (1 - x_{n-1})}{x[n] = r * x[n-1] * (1
  - x[n-1])} The default selection for the \emph{r}
  parameter is known to produce a deterministic chaotic
  time series.
}
\note{
  Some initial values may lead to an unstable system that
  will tend to infinity.
}
\examples{
\dontrun{
log.map=logisticMap(n.sample = 1000, n.transient=10,do.plot=TRUE)
}
}
\author{
  Constantino A. Garcia
}
\references{
  Strogatz, S.: Nonlinear dynamics and chaos: with
  applications to physics, biology, chemistry and
  engineering (Studies in Nonlinearity)
}
\seealso{
  \code{\link{henon}, \link{lorenz}, \link{rossler},
  \link{ikedaMap}, \link{cliffordMap}, \link{sinaiMap},
  \link{gaussMap}}
}

