% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{docdb_delete}
\alias{docdb_delete}
\title{Delete documents or container}
\usage{
docdb_delete(src, key, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
or \code{\link[=src_postgres]{src_postgres()}}}

\item{key}{(character) A key as name of the container
(corresponds to parameter \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch and to
a table name for SQLite and for PostgreSQL)}

\item{...}{optional \code{query} parameter with a JSON query as per
\code{\link[mongolite:mongo]{mongolite::mongo()}} and as working in \code{\link[=docdb_query]{docdb_query()}} to identify
documents to be deleted. The default is to delete the container
\code{key}.
Other parameters are passed on to functions:
\itemize{
\item MongoDB: find() in \code{\link[mongolite:mongo]{mongolite::mongo()}}
\item SQLite: ignored
\item Elasticsearch: \code{\link[elastic:Search]{elastic::Search()}}
\item CouchDB: \code{\link[sofa:db_alldocs]{sofa::db_alldocs()}}
\item PostgreSQL: ignored
}}
}
\value{
(logical) success of operation. Typically \code{TRUE} if document
or collection existed and \code{FALSE} is document did not exist or
collection did not exist or delete was not successful.
}
\description{
Delete documents or container
}
\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src, "iris", iris)
docdb_delete(src, "iris", query = '{"Species": {"$regex": "a$"}}')
docdb_delete(src, "iris")
}
}
