% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsAijmat}
\alias{funsAijmat}
\alias{aij.mat}
\alias{aij.nonzero}
\title{Aij matrices for computation of Moments of Cuzick and Edwards \eqn{T_k} Test statistic}
\usage{
aij.mat(dat, k, ...)

aij.nonzero(dat, k, ...)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{k}{Integer specifying the number of NNs (of subject \eqn{i}), default is \code{1}.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
The function \code{aij.mat} returns the \eqn{A_{ij}} matrix for computation of moments of Cuzick and Edwards \eqn{T_k}
Test statistic while the function \code{aij.nonzero} returns the (locations of the) non-zero entries in the \eqn{A_{ij}}
matrix
}
\description{
Two functions: \code{aij.mat} and \code{aij.nonzero}.

The function \code{aij.mat} yields the \eqn{A=(a_{ij}(k))} matrix where \eqn{a_{ij}(k) = 1} if \eqn{z_j} is among the \code{k}NNs of \eqn{z_i}
and 0 otherwise due to \insertCite{tango:2007;textual}{nnspat}.
This matrix is useful in calculation of the moments of Cuzick-Edwards \eqn{T_k} tests.
   
The function \code{aij.nonzero} keeps only nonzero entries, i.e., row and column entries where 
in each row, for the entry \eqn{(r_1,c_1)} \eqn{r_1} is the row entry and \eqn{c_1} is the column entry. Rows are from
1 to n, which stands for the data point or observation, and column entries are from 1 to \code{k}, where \code{k} is specifying
the number of \code{k}NNs (of each observation) considered. This function saves in storage memory, but needs to be
carefully unfolded in the functions to represent the actual the \eqn{A} matrix.

See also (\insertCite{tango:2007;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
k<-3 #try also 2,3

Aij<-aij.mat(Y,k)
Aij
Aij2<-aij.mat(Y,k,method="max")
range(Aij,Aij2)

apply(Aij,2,sum) #row sums of Aij

aij.nonzero(Y,k)
aij.nonzero(Y,k,method="max")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{aij.theta}} and \code{\link{EV.Tkaij}}
}
\author{
Elvan Ceyhan
}
