% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{cov.nnsym}
\alias{cov.nnsym}
\title{Covariance Matrix of the Differences of the Off-Diagonal Cell Counts in an NNCT}
\usage{
cov.nnsym(covN)
}
\arguments{
\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT}
}
\value{
The \eqn{k(k-1)/2 \times k(k-1)/2} covariance matrix of the differences of the off-diagonal cell counts \eqn{N_{ij}-N_{ji}} 
for \eqn{i,j=1,\ldots,k} and \eqn{i \ne j} in the NNCT, \code{ct}
}
\description{
Returns the covariance matrix of the differences of the cell counts, \eqn{N_{ij}-N_{ji}} 
for \eqn{i,j=1,\ldots,k} and \eqn{i \ne j}, in the NNCT, \code{ct}.
The covariance matrix is of dimension \eqn{k(k-1)/2 \times k(k-1)/2} and its entries are
\eqn{cov(N_{ij}-N_{ji}, N_{kl}-N_{lk})} where the order of \eqn{i,j} for \eqn{N_{ij}-N_{ji}} is as
in the output of \code{\link{ind.nnsym}(k)}. 
These covariances are valid under RL or conditional on \eqn{Q} and \eqn{R} under CSR.

The argument \code{covN} is the covariance matrix of \eqn{N_{ij}} (concatenated rowwise).

See also (\insertCite{dixon:1994,ceyhan:SWJ-spat-sym2014;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv) #default is byrow

cov.nnsym(covN)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

cov.nnsym(covN)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{var.nnsym}}, \code{\link{cov.tct}}, \code{\link{cov.nnct}} and \code{\link{cov.seg.coeff}}
}
\author{
Elvan Ceyhan
}
