% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{bvnorm.pdf}
\alias{bvnorm.pdf}
\title{pdf of the Bivariate Normal Distribution}
\usage{
bvnorm.pdf(X, mu = c(0, 0), s1 = 1, s2 = 1, rho = 0)
}
\arguments{
\item{X}{A set of 2D points of size \eqn{n} (i.e an \eqn{n \times 2} matrix or array) at which the density of the bivariate normal distribution
is to be computed.}

\item{mu}{A \eqn{1 \times 2} \code{vector} of real numbers representing the mean of the bivariate normal distribution,
default=\eqn{(0,0)}.}

\item{s1, s2}{The standard deviations of the first and second components of the bivariate normal distribution,
with default is \code{1} for both}

\item{rho}{The correlation between the first and second components of the bivariate normal distribution
with default=0.}
}
\value{
The value of the probability density function (i.e. density) of the bivariate normal distribution
at the specified point \code{X}, with mean \code{mu} and standard deviations of the first and second components being \eqn{s_1}
and \eqn{s_2} and correlation between them being \code{rho}.
}
\description{
Computes the value of the probability density function (i.e. density) of the bivariate normal distribution
at the specified point \code{X}, with mean \code{mu} and standard deviations of the first and second components being \eqn{s_1}
and \eqn{s_2} (denoted as \code{s1} and \code{s2} in the arguments of the function, respectively) 
and correlation between them being \code{rho} (i.e., the covariance matrix is \eqn{\Sigma=S} where \eqn{S_{11}=s_1^2},
\eqn{S_{22}=s_2^2}, \eqn{S_{12}=S_{21}=s_1 s_2 rho}).
}
\examples{
mu<-c(0,0)
s1<-1
s2<-1
rho<-.5

n<-5
Xp<-cbind(runif(n),runif(n))
bvnorm.pdf(Xp,mu,s1,s2,rho)
}
\seealso{
\link[MASS]{mvrnorm}
}
\author{
Elvan Ceyhan
}
