% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001functions.R
\name{maxle}
\alias{maxle}
\title{\code{maxle} returns expression of log-likelihood (LL) of joint normal distribution.}
\usage{
maxle(cheqs0, fixed_term = TRUE)
}
\arguments{
\item{cheqs0}{Strings defining equations of errors. Systems of Nonlinear Regressions (SNR) variant.}

\item{fixed_term}{if \code{TRUE} fixed term -(k/2)*log(2*pi) (k number of equations) is included}
}
\value{
List with LL expressions of joint normal distribution, first element is string with 
expression for derivative calculations, the second - string for evaluation.
}
\description{
\code{maxle} returns expression of log-likelihood (LL) of joint normal distribution.
}
\examples{
# normal distribution
eq_c <- c("Tw ~ ((((PH) + (tw)) * (ta - Tc + 2) + (1 + (tw)) * (Ec/w - 2/w) -(1 + (PH))) +
sqrt((((PH) + (tw)) * (ta - Tc + 2) + (1 +(tw)) * (Ec/w - 2/w) - (1 + (PH)))^2 - 4 * (1 + (PH) +
 (tw)) *(-(PH) * (ta - Tc + 2) + (1 - (tw) * (ta - Tc + 2)) * (2/w -Ec/w))))/(2 * (1 + (PH) +
  (tw)))",
"Tf1 ~ (th1) * (ta - (((((PH) + (tw)) * (ta - Tc + 2) + (1 + (tw)) *(Ec/w - 2/w) - (1 + (PH))) +
 sqrt((((PH) + (tw)) * (ta -Tc + 2) + (1 + (tw)) * (Ec/w - 2/w) - (1 + (PH)))^2 - 4 *(1 + (PH) +
 (tw)) * (-(PH) * (ta - Tc + 2) + (1 - (tw) *(ta - Tc + 2)) * (2/w - Ec/w))))/(2 * (1 + (PH) +
  (tw)))) -Tc + 2) - 1",
"Ef1 ~ (ph1)/(PH) * (w * (((((PH) + (tw)) * (ta - Tc + 2) + (1 +(tw)) * (Ec/w - 2/w) -
(1 + (PH))) + sqrt((((PH) + (tw)) *(ta - Tc + 2) + (1 + (tw)) * (Ec/w - 2/w) - (1 + (PH)))^2 -4 *
 (1 + (PH) + (tw)) * (-(PH) * (ta - Tc + 2) + (1 - (tw) *(ta - Tc + 2)) * (2/w - Ec/w))))/(2 *
  (1 + (PH) + (tw)))) -Ec + 2) - 1")
parl <- c("tw","PH","th1","ph1")
para_cont <- get_par(parl, eq_c)
cheqs0 <- para_cont$cheqs0
res <- maxle(cheqs0=cheqs0)
}
