% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSmoh.R
\name{SSmoh}
\alias{SSmoh}
\alias{moh}
\title{self start for modified hyperbola (photosynthesis)}
\usage{
moh(x, asym, xmin, k)

SSmoh(x, asym, xmin, k)
}
\arguments{
\item{x}{input vector (x) which is normally a controlling variable such as nitrogen}

\item{asym}{asymptotic value when x tends to infinity}

\item{xmin}{value of x for which y equals zero}

\item{k}{curvature parameter}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

moh: vector of the same length as x (time) using the modified hyperbola
}
\description{
Self starter for modified Hyperbola with parameters: asymp, xmin and k
}
\details{
This function is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
See Table S3 (Eq. 3.8)
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- seq(3, 30)
y <- moh(x, 35, 3, 0.83) + rnorm(length(x), 0, 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSmoh(x, asym, xmin, k), data = dat)
## Visualize observed and simulated
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
## Testing predict function
prd <- predict_nls(fit, interval = "confidence")
datA <- cbind(dat, prd)
## Plotting
ggplot(data = datA, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit))) + 
  geom_ribbon(aes(ymin = Q2.5, ymax = Q97.5), 
  fill = "purple", alpha = 0.3)
}
x <- seq(0, 20)
y <- moh(x, 30, 3, 0.9)
plot(x, y)
}
