% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_nls.R
\name{predict_gam}
\alias{predict_gam}
\title{Modified prediciton function based on predict.gam}
\usage{
predict_gam(
  object,
  newdata = NULL,
  type = "link",
  se.fit = TRUE,
  terms = NULL,
  exclude = NULL,
  block.size = NULL,
  newdata.guaranteed = FALSE,
  na.action = na.pass,
  unconditional = FALSE,
  iterms.type = NULL,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  tvalue = NULL,
  ...
)
}
\arguments{
\item{object}{object of class \sQuote{gam} or as returned by function \sQuote{gamm}}

\item{newdata}{see \code{\link[mgcv]{predict.gam}}}

\item{type}{see \code{\link[mgcv]{predict.gam}}}

\item{se.fit}{see \code{\link[mgcv]{predict.gam}}. Notice that the default is changed to TRUE.}

\item{terms}{see \code{\link[mgcv]{predict.gam}}}

\item{exclude}{see \code{\link[mgcv]{predict.gam}}}

\item{block.size}{see \code{\link[mgcv]{predict.gam}}}

\item{newdata.guaranteed}{see \code{\link[mgcv]{predict.gam}}}

\item{na.action}{see \code{\link[mgcv]{predict.gam}}}

\item{unconditional}{see \code{\link[mgcv]{predict.gam}}}

\item{iterms.type}{see \code{\link[mgcv]{predict.gam}}}

\item{interval}{either \sQuote{none}, \sQuote{confidence} or \sQuote{prediction}.}

\item{level}{probability level for the interval (default 0.95)}

\item{tvalue}{t-value statistic used for constructing the intervals}

\item{...}{additional arguments to be passed to \code{\link[mgcv]{predict.gam}}.}
}
\value{
numeric vector of the same length as the fitted object when interval is equal to \sQuote{none}. 
Otherwise, a data.frame with columns named (for a 0.95 level) 
\sQuote{Estimate}, \sQuote{Est.Error}, \sQuote{Q2.5} and \sQuote{Q97.5}
}
\description{
Largely based on predict.gam, but with some minor modifications to make it compatible
with \code{\link{predict_nls}}
}
\note{
this is a very simple wrapper for \code{\link[mgcv]{predict.gam}}.
}
\examples{
\donttest{
require(ggplot2)
require(mgcv)
data(barley)

fm.G <- gam(yield ~ s(NF, k = 6), data = barley)

## confidence and prediction intervals
cis <- predict_gam(fm.G, interval = "conf")
pis <- predict_gam(fm.G, interval = "pred")

barleyA.ci <- cbind(barley, cis)
barleyA.pi <- cbind(barley, pis)

ggplot() + 
  geom_point(data = barleyA.ci, aes(x = NF, y = yield)) + 
  geom_line(data = barleyA.ci, aes(x = NF, y = Estimate)) + 
  geom_ribbon(data = barleyA.ci, aes(x = NF, ymin = Q2.5, ymax = Q97.5), 
              color = "red", alpha = 0.3) + 
  geom_ribbon(data = barleyA.pi, aes(x = NF, ymin = Q2.5, ymax = Q97.5), 
              color = "blue", alpha = 0.3) + 
  ggtitle("95\% confidence and prediction bands")
  
}
}
\seealso{
\code{\link[stats]{predict.lm}}, \code{\link[stats]{predict.nls}}, \code{\link[mgcv]{predict.gam}}, \code{\link{simulate_nls}}, \code{\link{simulate_gam}}
}
