% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_nlme.R
\name{predict_nlme}
\alias{predict_nlme}
\alias{predict_lme}
\title{Average predictions from several (non)linear models based on IC weights}
\usage{
predict_nlme(
  ...,
  criteria = c("AIC", "AICc", "BIC"),
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  nsim = 1000,
  plevel = 0,
  newdata = NULL
)

predict_lme(
  ...,
  criteria = c("AIC", "AICc", "BIC"),
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  nsim = 1000,
  plevel = 0,
  newdata = NULL
)
}
\arguments{
\item{...}{nlme, lme, gls or gnls objects.}

\item{criteria}{either \sQuote{AIC}, \sQuote{AICc} or \sQuote{BIC}.}

\item{interval}{either \sQuote{none}, \sQuote{confidence} or \sQuote{prediction}.}

\item{level}{probability level for the interval (default 0.95)}

\item{nsim}{number of simulations to perform for intervals. Default 1000.}

\item{plevel}{parameter level prediction to be passed to prediciton functions.}

\item{newdata}{new data frame for predictions}
}
\value{
numeric vector of the same length as the fitted object.
}
\description{
Computes weights based on AIC, AICc, or BIC and it generates weighted predictions by
the relative value of the IC values

predict function for objects of class \code{\link[nlme]{lme}}
}
\note{
all the objects should be fitted to the same data. The weights are
based on the IC value.
}
\examples{
\donttest{
## Example
require(ggplot2)
require(nlme)
data(Orange)

## All models should be fitted using Maximum Likelihood
fm.L <- nlme(circumference ~ SSlogis(age, Asym, xmid, scal), 
                random = pdDiag(Asym + xmid + scal ~ 1), 
                method = "ML", data = Orange)
fm.G <- nlme(circumference ~ SSgompertz(age, Asym, b2, b3), 
                random = pdDiag(Asym + b2 + b3 ~ 1), 
                method = "ML", data = Orange)
fm.F <- nlme(circumference ~ SSfpl(age, A, B, xmid, scal), 
                random = pdDiag(A + B + xmid + scal ~ 1), 
                method = "ML", data = Orange)
fm.B <- nlme(circumference ~ SSbg4rp(age, w.max, lt.e, ldtm, ldtb), 
                random = pdDiag(w.max + lt.e + ldtm + ldtb ~ 1), 
                method = "ML", data = Orange)

## Print the table with weights
IC_tab(fm.L, fm.G, fm.F, fm.B)

## Each model prediction is weighted according to their AIC values
prd <- predict_nlme(fm.L, fm.G, fm.F, fm.B)

ggplot(data = Orange, aes(x = age, y = circumference)) + 
  geom_point() + 
  geom_line(aes(y = predict(fm.L, level = 0), color = "Logistic")) +
  geom_line(aes(y = predict(fm.G, level = 0), color = "Gompertz")) +
  geom_line(aes(y = predict(fm.F, level = 0), color = "4P-Logistic")) +  
  geom_line(aes(y = predict(fm.B, level = 0), color = "Beta")) +
  geom_line(aes(y = prd, color = "Avg. Model"), size = 1.2)
}
}
\seealso{
\code{\link{predict.nlme}} \code{\link{predict.lme}} \code{\link{predict.gnls}}
}
