% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSbgrp.R
\name{SSbgrp}
\alias{SSbgrp}
\alias{bgrp}
\title{self start for the reparameterized Beta growth function}
\usage{
bgrp(time, w.max, lt.e, ldt)

SSbgrp(time, w.max, lt.e, ldt)
}
\arguments{
\item{time}{input vector (x) which is normally \sQuote{time}, the smallest value should be close to zero.}

\item{w.max}{value of weight or mass at its peak}

\item{lt.e}{log of the time at which the maximum weight or mass has been reached.}

\item{ldt}{log of the difference between time at which the weight or mass reaches its peak and half its peak (\eqn{log(t.e - t.m)}).}
}
\value{
bgrp: vector of the same length as x (time) using the beta growth function (reparameterized).
}
\description{
Self starter for Beta Growth function with parameters w.max, lt.m and ldt
}
\details{
For details see the publication by Yin et al. (2003) \dQuote{A Flexible Sigmoid Function of Determinate Growth}.
This is a reparameterization of the beta growth function with guaranteed constraints, so it is expected to 
behave numerically better than \code{\link{SSbgf}}.

The form of the equation is: \deqn{w.max * (1 + (exp(lt.e) - time)/exp(ldt)) * (time/exp(lt.e))^(exp(lt.e) / exp(ldt))}.
Given this function weight is expected to decay and reach zero again at \eqn{2*ldt}. This is a reparameterized version 
of the Beta-Growth function in which the parameters are unconstrained, but they are expressed in the log-scale.
}
\note{
In a few tests it seems that zero values of \sQuote{time} can cause the error message \sQuote{NA/NaN/Inf in foreign function call (arg 1)}, so it might be better to remove them before running this function.
}
\examples{
\donttest{
require(ggplot2)
x <- 1:30
y <- bgrp(x, 20, log(25), log(5)) + rnorm(30, 0, 1)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSbgrp(x, w.max, lt.e, ldt), data = dat)
## We are able to recover the original values
exp(coef(fit)[2:3])
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
