% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIX.SUBMODEL.LCSM_helper.R
\name{getsub.LCSM_l}
\alias{getsub.LCSM_l}
\title{Define Latent Change Score Models as Class-specific Models (Submodels) for a Longitudinal Mixture Model}
\usage{
getsub.LCSM_l(
  dat,
  nClass,
  t_var,
  records,
  y_var,
  curveFun,
  intrinsic,
  growth_TIC,
  starts
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements and occasions for each longitudinal process, and time-invariant covariates (TICs) if any.
It takes the value passed from \code{getMIX()}.}

\item{nClass}{An integer specifying the number of latent classes for the mixture model. It takes the value passed from \code{getMIX()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getMIX()}.}

\item{records}{A numeric vector specifying indices of the study waves. It takes the value passed from \code{getMIX()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getMIX()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for latent change score
models include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}), \code{"Jenss-Bayley"}
(or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the value passed from \code{getMIX()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the value
passed from \code{getMIX()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) contributing to the
variability of growth factors if any. It takes the value passed from \code{getMIX()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getMIX()} or
derived by the helper function \code{getMIX.initial()}.}
}
\value{
A list of manifest and latent variables and paths for an mxModel object.
}
\description{
This function defines latent change score models as class-specific models (submodels) for a longitudinal mixture model.
}
