% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassocov.R
\name{lassoCoefficients}
\alias{lassoCoefficients}
\title{Return Final lasso coefficients after finding optimal t}
\usage{
lassoCoefficients(
  fit,
  varsVec,
  covarsVec,
  catvarsVec,
  constraint = 1e-08,
  stratVar = NULL,
  ...
)
}
\arguments{
\item{fit}{nlmixr2 fit.}

\item{varsVec}{character vector of variables that need to be added}

\item{covarsVec}{character vector of covariates that need to be added}

\item{catvarsVec}{character vector of categorical covariates that need to be added}

\item{constraint}{theta cutoff. below cutoff then the theta will be fixed to zero}

\item{stratVar}{A variable to stratify on for cross-validation}

\item{...}{Other parameters to be passed to optimalTvaluelasso}
}
\value{
return data frame of final lasso coefficients
}
\description{
Return Final lasso coefficients after finding optimal t
}
\examples{
\dontrun{
one.cmt <- function() {
  ini({
    tka <- 0.45; label("Ka")
    tcl <- log(c(0, 2.7, 100)); label("Cl")
    tv <- 3.45; label("V")
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
  })
}

d <- nlmixr2data::theo_sd
d$SEX <-0
d$SEX[d$ID<=6] <-1

fit <- nlmixr2(one.cmt, d, est = "saem", control = list(print = 0))
varsVec <- c("ka","cl","v")
covarsVec <- c("WT")
catvarsVec <- c("SEX")

# Lasso coefficients:

lassoDf <- lassoCoefficients(fit, varsVec, covarsVec, catvarsVec, constraint=1e-08, stratVar = NULL)
}
}
\author{
Vishal Sarsani
}
