% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc.R
\name{vpcSim}
\alias{vpcSim}
\title{VPC simulation}
\usage{
vpcSim(object, ..., keep = NULL, n = 300, pred = FALSE, seed = 1009)
}
\arguments{
\item{object}{This is the nlmixr2 fit object}

\item{...}{Other arguments sent to `rxSolve()`}

\item{keep}{Keep character vector}

\item{n}{Number of simulations}

\item{pred}{Should predictions be added to the simulation}

\item{seed}{Seed to set for the VPC simulation}
}
\value{
data frame of the VPC simulation
}
\description{
VPC simulation
}
\examples{

\donttest{
one.cmt <- function() {
 ini({
   ## You may label each parameter with a comment
   tka <- 0.45 # Log Ka
   tcl <- log(c(0, 2.7, 100)) # Log Cl
   ## This works with interactive models
   ## You may also label the preceding line with label("label text")
   tv <- 3.45; label("log V")
   ## the label("Label name") works with all models
   eta.ka ~ 0.6
   eta.cl ~ 0.3
   eta.v ~ 0.1
   add.sd <- 0.7
 })
 model({
   ka <- exp(tka + eta.ka)
   cl <- exp(tcl + eta.cl)
   v <- exp(tv + eta.v)
   linCmt() ~ add(add.sd)
 })
}

fit <- nlmixr(one.cmt, theo_sd, est="focei")

head(vpcSim(fit, pred=TRUE))

}
}
\author{
Matthew L. Fidler
}
